
;
; Entries :	DVA
;		DVR
;		FRR
;		DFR
;		DRA
;		DRR
;		DSF
;		WSF
;		ESF

dva:
	php
	rep	#0x30

	bsl	setabs
	sep	#0x20
	lda	<lstyle		; doing non-solid lines ?
	beq	$1
	sta	Rbstip		; set stipple pattern.
	lda	#1
	tsb	DaCtl		; enable stippling.
	bra	$2
$1:	inc	a		; set acc = 1.
	trb	DaCtl		; turn off stippling.
$2:	sta	DaDva		; draw the vector.

	stx	<xpos
	sty	<ypos
	plp
	rtl

dfr:
	php
	rep	#0x30
	lda	<stpnum
	beq	$1
	jsl	>0,Gcoor
	sec
	txa
	sbc	<xpos
	tax
	sec
	tya
	sbc	<ypos
	tay
	brl	stpdfr
$1:
	bsl	setabs
	sep	#0x20
	lda	#1
	trb	DaCtl

$2:	sta	DaDfr
	stx	<xpos
	sty	<ypos
	plp
	rtl

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Draw stipple filled rectangle.	;
; Enter with relative coords of opp	;
; corner in x,y.			;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

stpdfr:

$dx	equ	temp2+2
$dy	equ	temp2+4
$newx	equ	temp2+6
$newy	equ	temp2+8

	lda	<stpnum
	dec	a
	asl	a
	asl	a
	asl	a
	adc	<stpbuf
	sta	<temp		; save pointer to definition.

	stx	<$dx
	sty	<$dy

	clc
	txa
	adc	<xpos
	sta	<$newx
	tax

	clc
	tya
	adc	<ypos
	sta	<$newy
	tay

$wdp:	bit	Dpdone-1
	bvc	$wdp

	bit	<$dx
	bmi	$xdn
	stx	0xfe00
	lda	<xpos
	sta	Xcap
	tax
	bra	$chky
$xdn:	stx	Xcap
	lda	<xpos
	sta	0xfe00		
$chky:
	bit	<$dy
	bmi	$ydn
	sty	0xfe02
	lda	<ypos
	sta	Ycap
	tay
	bra	$doit
$ydn:	sty	Ycap
	lda	<ypos
	sta	0xfe02		
$doit:	

;	
; turn on stipple bit,
; align and load stipple pattern.
; x, y reg are coords of ll corner.
;

	sep	#0x30		; 8 bit m,x.
	lda	#1		; turn on stipple.
	tsb	DaCtl

	tya
	and	#7		; index first patt to use.
	tay	

	txa
	and	#7		; # shifts needed to align x.
	stx	<temp1
	stz	<temp2		; index into param registers.
$loop:
	lda	(<temp),y	; get stipple to use.
	iny			; point to next.
	cpy	#8		; need to wrap ?
	bcc	$yok		; br if no.
	ldy	#0		; ok, so wrap.
$yok:	ldx	<temp1		; get # rotates needed to align x.
	beq	$xok		; br if no shift needed.
$align:	asl	a		; shift left 1 bit.
	adc	#0		; move bit 7 to bit 0.
	dex			; more shifts needed ?
	bne	$align		; loop if yes.
$xok:	ldx	<temp2		; get index into param registers.
	rep	#0x20
	sta	0xfe10,x	; need to write high byte as well.
	sep	#0x20
	inx			; bump param reg index.
	inx
	stx	<temp2		; save for next stipple.
	cpx	#16		; all registers loaded ?
	bcc	$loop		; loop if no.

	sta	DaDfr		; draw the rectangle (whew).
;
; update xpos, ypos.
;
	rep	#0x30
	lda	<$newx
	sta	<xpos
	lda	<$newy
	sta	<ypos

	plp
	rtl



dra:
	php
	rep	#0x30
	bsl	setabs
	sep	#0x20
	lda	<lstyle		; doing non-solid lines ?
	beq	$1
	sta	Rbstip		; set stipple pattern.
	lda	#1
	tsb	DaCtl		; enable stippling.
	bra	$2
$1:	inc	a		; set acc = 1.
	trb	DaCtl		; turn off stippling.
$2:
	rep	#0x20
	ldx	<ypos
	stx	0xfe02		; draw to newx,ypos.
	sta	DaDva
$3:	bit	Dpdone-1	; wait for dpu done.
	bvc	$3
	sty	0xfe02		; draw to newx, newy.
	sta	DaDva
	lda	<xpos
$4:	bit	Dpdone-1	; wait for dpu done.
	bvc	$4
	sta	0xfe00		; draw to xpos, newy.
	sta	DaDva
$5:	bit	Dpdone-1	; wait for dpu done.
	bvc	$5
	stx	0xfe02		; draw to xpos,ypos.
	sta	DaDva
	plp
	rtl

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Common setup for dva,dfr,dra.	;
; Call gcoor to get endpoint in	;
; x,y registers, put endpoint 	;
; in parameter registers, set	;
; Xcap, Ycap = xpos, ypos.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

setabs:

				; get endoint of vector or
	jsl	>0,Gcoor	; opposite corner of rectangle
				; in x, y registers.
$1:	bit	Dpdone-1	; wait for dpu done.
	bvc	$1
;
; set up drawing accelerator
; parameters for dva or dfr.
;
	stx	0xfe00		; set x endpoint.
	lda	<xpos		; get x starting point
	sta	Xcap		; set x cap.
	lda	<ypos		; ditto y.
	sta	Ycap
	sty	0xfe02
	rts


dvr:
	php
	rep	#0x30
	bsl	setrel
	sep	#0x20
	lda	<lstyle		; doing non-solid lines ?
	beq	$1
	sta	Rbstip		; set stipple pattern.
	lda	#1
	tsb	DaCtl		; enable stippling.
	bra	$2
$1:	inc	a		; set acc = 1.
	trb	DaCtl		; turn off stippling.
$2:	sta	DaDvr		; draw the vector.
	brl	reldon

frr:
	php
	rep	#0x30
	lda	<stpnum
	beq	$1
	jsl	>0,Gdxdy
	brl	stpdfr
$1:
	bsl	setrel
	sep	#0x20
	lda	#1
	trb	DaCtl
	sta	DaFrr
	brl	reldon

dmv:
	php
	sep	#0x20
	lda	<lstyle		; doing non-solid lines ?
	beq	$1
	sta	Rbstip		; set stipple pattern.
	lda	#1
	tsb	DaCtl		; enable stippling.
	bra	$2
$1:	inc	a		; set acc = 1.
	trb	DaCtl		; turn off stippling.
$2:	rep	#0x30

$loop:
	bsl	setrel
	txa
	bne	$ok
	tya
	bne	$ok
	plp
	rtl
$ok
	sta	DaDvr
	txa
	clc
	adc	<xpos
	sta	<xpos
	tya
	clc
	adc	<ypos
	sta	<ypos
	bra	$loop

drr:
	php
	sep	#0x20
	lda	<lstyle		; doing non-solid lines ?
	beq	$10
	sta	Rbstip		; set stipple pattern.
	lda	#1
	tsb	DaCtl		; enable stippling.
	bra	$20
$10:	inc	a		; set acc = 1.
	trb	DaCtl		; turn off stippling.

$20:	rep	#0x30
	bsl	setrel

	stz	0xfe02
	sta	DaDvr

$1:	bit	Dpdone-1
	bvc	$1

	sty	0xfe02
	stz	0xfe00
	sta	DaDvr

$2:	bit	Dpdone-1
	bvc	$2

	stz	0xfe02
	txa
	eor	##-1
	inc	a

$3:	bit	Dpdone-1
	bvc	$3

	sta	0xfe00
	sta	DaDvr

	stz	0xfe00
	tya
	eor	##-1
	inc	a

$4:	bit	Dpdone-1
	bvc	$4

	sta	0xfe02
	sta	DaDvr

	plp
	rtl

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Common setup for dvr,frr,drr,dmv.	;
; Call gdxdy to get signed x,y offsets	;
; in x,y registers, put offsets in the	;
; parameter registers, set Xcap, Ycap	;
; to xpos, ypos.			;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

setrel:

	jsl	>0,Gdxdy

$1:	bit	Dpdone-1		; wait for dpu done.
	bvc	$1

	stx	0xfe00
	lda	<xpos
	sta	Xcap

	sty	0xfe02
	lda	<ypos
	sta	Ycap
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Common exit from dvr,frr.	;
; Add the offsets to xpos, ypos	;
; and return to interpreter.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

reldon:
	rep	#0x30
	txa
	clc
	adc	<xpos
	sta	<xpos
	tya
	clc
	adc	<ypos
	sta	<ypos
	plp
	rtl

;dsf
;wsf

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ESF - erase special font.		;
; esf(dh,dv,dx,dy) is equivalent to	;
; sec(0),frr(dh-1,dv-1),mvr(dx,dy),	;
; sec(back to what it was).		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

esf:
	php
	rep	#0x30

	jsl	>0,Gdxdy	; get rectangle size in pixels.
	dex			; convert to offset of
	dey			; opposite corner for frr.

$1:	bit	Dpdone-1
	bvc	$1

;
; set up for and do the frr.
;
	lda	##1
	trb	DaFlag		; turn off stippling.
	stz	DaColr		; draw in color 0.
	stx	0xfe00
	sty	0xfe02
	lda	<xpos
	sta	Xcap
	lda	<ypos
	sta	Ycap
	sta	DaFrr		; draw rectangle.
;
; do the mvr.
;
	jsl	>0,Gdxdy
	clc
	txa
	adc	<xpos
	sta	<xpos
	clc
	tya
	adc	<ypos
	sta	<ypos
;
; restore color and return.
;
	sep	#0x20
$2:	bit	Dpdone
	bvc	$2
	lda	<color
	sta	DaColr
	plp
	rtl



	end


